/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.History;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManager;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WebWindowImpl
implements WebWindow {
    private static final Log LOG = LogFactory.getLog(WebWindowImpl.class);
    private WebClient webClient_;
    private Page enclosedPage_;
    private ScriptableObject scriptObject_;
    private JavaScriptJobManager jobManager_;
    private final List<WebWindowImpl> childWindows_ = new ArrayList<WebWindowImpl>();
    private String name_ = "";
    private final History history_ = new History(this);
    private boolean closed_;
    private int innerHeight_;
    private int outerHeight_;
    private int innerWidth_;
    private int outerWidth_;

    public WebWindowImpl(WebClient webClient) {
        WebAssert.notNull("webClient", webClient);
        this.webClient_ = webClient;
        this.jobManager_ = BackgroundJavaScriptFactory.theFactory().createJavaScriptJobManager(this);
        boolean plus16 = false;
        this.innerHeight_ = 605;
        if (webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_OUTER_INNER_HEIGHT_DIFF_63)) {
            this.outerHeight_ = this.innerHeight_ + 63;
            plus16 = true;
        } else if (webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_OUTER_INNER_HEIGHT_DIFF_94)) {
            this.outerHeight_ = this.innerHeight_ + 94;
        } else if (webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_OUTER_INNER_HEIGHT_DIFF_89)) {
            this.outerHeight_ = this.innerHeight_ + 89;
            plus16 = true;
        } else {
            this.outerHeight_ = this.innerHeight_ + 115;
        }
        this.innerWidth_ = 1256;
        this.outerWidth_ = plus16 ? this.innerWidth_ + 16 : this.innerWidth_ + 14;
    }

    protected void performRegistration() {
        this.webClient_.registerWebWindow(this);
    }

    @Override
    public WebClient getWebClient() {
        return this.webClient_;
    }

    @Override
    public Page getEnclosedPage() {
        return this.enclosedPage_;
    }

    @Override
    public void setEnclosedPage(Page page) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setEnclosedPage: " + page);
        }
        if (page == this.enclosedPage_) {
            return;
        }
        this.destroyChildren();
        this.enclosedPage_ = page;
        this.history_.addPage(page);
        if (this.isJavaScriptInitializationNeeded()) {
            this.webClient_.initialize(this);
        }
        this.webClient_.initialize(page);
    }

    protected abstract boolean isJavaScriptInitializationNeeded();

    @Override
    public void setScriptableObject(ScriptableObject scriptObject) {
        this.scriptObject_ = scriptObject;
    }

    @Override
    public Object getScriptObject() {
        return this.getScriptableObject();
    }

    @Override
    public ScriptableObject getScriptableObject() {
        return this.scriptObject_;
    }

    @Override
    public JavaScriptJobManager getJobManager() {
        return this.jobManager_;
    }

    public void setJobManager(JavaScriptJobManager jobManager) {
        this.jobManager_ = jobManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildWindow(FrameWindow child) {
        List<WebWindowImpl> list = this.childWindows_;
        synchronized (list) {
            this.childWindows_.add(child);
        }
    }

    protected void destroyChildren() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("destroyChildren");
        }
        this.getJobManager().removeAllJobs();
        while (!this.childWindows_.isEmpty()) {
            WebWindowImpl window = this.childWindows_.get(0);
            this.removeChildWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildWindow(WebWindowImpl window) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("closing child window: " + window);
        }
        window.setClosed();
        window.getJobManager().shutdown();
        Page page = window.getEnclosedPage();
        if (page != null) {
            page.cleanUp();
        }
        window.destroyChildren();
        List<WebWindowImpl> list = this.childWindows_;
        synchronized (list) {
            this.childWindows_.remove(window);
        }
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String name) {
        this.name_ = name;
    }

    @Override
    public History getHistory() {
        return this.history_;
    }

    @Override
    public boolean isClosed() {
        return this.closed_;
    }

    protected void setClosed() {
        this.closed_ = true;
    }

    @Override
    public int getInnerWidth() {
        return this.innerWidth_;
    }

    @Override
    public void setInnerWidth(int innerWidth) {
        this.innerWidth_ = innerWidth;
    }

    @Override
    public int getOuterWidth() {
        return this.outerWidth_;
    }

    @Override
    public void setOuterWidth(int outerWidth) {
        this.outerWidth_ = outerWidth;
    }

    @Override
    public int getInnerHeight() {
        return this.innerHeight_;
    }

    @Override
    public void setInnerHeight(int innerHeight) {
        this.innerHeight_ = innerHeight;
    }

    @Override
    public int getOuterHeight() {
        return this.outerHeight_;
    }

    @Override
    public void setOuterHeight(int outerHeight) {
        this.outerHeight_ = outerHeight;
    }
}

