/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.util.KeyDataPair;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlFileInput
extends HtmlInput {
    private static final String FILE_SEPARATOR = "\u00a7";
    private String contentType_;
    private byte[] data_;

    HtmlFileInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, HtmlFileInput.addValueIfNeeded(page, attributes));
        for (Map.Entry<String, DomAttr> entry : attributes.entrySet()) {
            if (!"value".equalsIgnoreCase(entry.getKey())) continue;
            this.setDefaultValue(entry.getValue().getNodeValue(), false);
        }
    }

    private static Map<String, DomAttr> addValueIfNeeded(SgmlPage page, Map<String, DomAttr> attributes) {
        HashMap<String, DomAttr> result = new HashMap<String, DomAttr>(attributes);
        DomAttr newAttr = new DomAttr(page, null, "value", "", true);
        result.put("value", newAttr);
        return result;
    }

    public final byte[] getData() {
        return this.data_;
    }

    public final void setData(byte[] data) {
        this.data_ = data;
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        String valueAttribute = this.getValueAttribute();
        if (StringUtils.isEmpty(valueAttribute)) {
            return new NameValuePair[]{new KeyDataPair(this.getNameAttribute(), null, null, null, null)};
        }
        ArrayList<KeyDataPair> list = new ArrayList<KeyDataPair>();
        for (File file : HtmlFileInput.splitFiles(valueAttribute)) {
            String contentType = this.contentType_ == null ? this.getPage().getWebClient().guessContentType(file) : this.contentType_;
            String charset = this.getPage().getPageEncoding();
            KeyDataPair keyDataPair = new KeyDataPair(this.getNameAttribute(), file, null, contentType, charset);
            keyDataPair.setData(this.data_);
            list.add(keyDataPair);
        }
        return list.toArray(new NameValuePair[list.size()]);
    }

    public static List<File> splitFiles(String valueAttribute) {
        LinkedList<File> files = new LinkedList<File>();
        for (String value : valueAttribute.split(FILE_SEPARATOR)) {
            File file = null;
            if (value.startsWith("file:/")) {
                if (value.startsWith("file://") && !value.startsWith("file:///")) {
                    value = "file:///" + value.substring(7);
                }
                try {
                    file = new File(new URI(value));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (file == null) {
                file = new File(value);
            }
            files.add(file);
        }
        return files;
    }

    @Override
    public void reset() {
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue, false);
    }

    public void setContentType(String contentType) {
        this.contentType_ = contentType;
    }

    public String getContentType() {
        return this.contentType_;
    }

    public Page setValueAttribute(String[] paths) {
        if (this.getAttribute("multiple") == ATTRIBUTE_NOT_DEFINED) {
            throw new IllegalStateException("HtmlFileInput is not 'multiple'.");
        }
        StringBuilder builder = new StringBuilder();
        for (String p : paths) {
            if (builder.length() != 0) {
                builder.append(FILE_SEPARATOR);
            }
            builder.append(p);
        }
        return super.setValueAttribute(builder.toString());
    }
}

