/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlMap;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlImage
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlImage.class);
    public static final String TAG_NAME = "img";
    public static final String TAG_NAME2 = "image";
    private final String originalQualifiedName_;
    private int lastClickX_;
    private int lastClickY_;
    private WebResponse imageWebResponse_;
    private transient ImageData imageData_;
    private boolean downloaded_;
    private boolean onloadInvoked_;
    private boolean createdByJavascript_;

    HtmlImage(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(HtmlImage.unifyLocalName(qualifiedName), page, attributes);
        this.originalQualifiedName_ = qualifiedName;
    }

    private static String unifyLocalName(String qualifiedName) {
        if (qualifiedName != null && qualifiedName.endsWith(TAG_NAME2)) {
            int pos = qualifiedName.lastIndexOf(TAG_NAME2);
            return qualifiedName.substring(0, pos) + TAG_NAME;
        }
        return qualifiedName;
    }

    @Override
    protected void onAddedToPage() {
        this.doOnLoad();
        super.onAddedToPage();
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        String oldValue;
        HtmlPage htmlPage = this.getHtmlPageOrNull();
        if ("src".equals(qualifiedName) && value != ATTRIBUTE_NOT_DEFINED && htmlPage != null && !(oldValue = this.getAttributeNS(namespaceURI, qualifiedName)).equals(value)) {
            super.setAttributeNS(namespaceURI, qualifiedName, value);
            this.onloadInvoked_ = false;
            this.downloaded_ = false;
            String readyState = htmlPage.getReadyState();
            if ("loading".equals(readyState)) {
                PostponedAction action = new PostponedAction(this.getPage()){

                    @Override
                    public void execute() throws Exception {
                        HtmlImage.this.doOnLoad();
                    }
                };
                htmlPage.addAfterLoadAction(action);
                return;
            }
            this.doOnLoad();
            return;
        }
        super.setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public void doOnLoad() {
        if (this.onloadInvoked_) {
            return;
        }
        HtmlPage htmlPage = this.getHtmlPageOrNull();
        if (htmlPage == null) {
            return;
        }
        WebClient client = htmlPage.getWebClient();
        if (!client.getOptions().isJavaScriptEnabled()) {
            this.onloadInvoked_ = true;
            return;
        }
        if (this.hasEventHandlers("onload") && !this.getSrcAttribute().isEmpty()) {
            boolean ok;
            this.onloadInvoked_ = true;
            try {
                this.downloadImageIfNeeded();
                int i = this.imageWebResponse_.getStatusCode();
                ok = i >= 200 && i < 300 || i == 305;
            }
            catch (IOException e) {
                ok = false;
            }
            if (ok) {
                final Event event = new Event(this, "load");
                final Node scriptObject = (Node)this.getScriptableObject();
                String readyState = htmlPage.getReadyState();
                if ("loading".equals(readyState)) {
                    PostponedAction action = new PostponedAction(this.getPage()){

                        @Override
                        public void execute() throws Exception {
                            scriptObject.executeEventLocally(event);
                        }
                    };
                    htmlPage.addAfterLoadAction(action);
                } else {
                    scriptObject.executeEventLocally(event);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to download image for tag " + this + "; not firing onload event.");
            }
        }
    }

    public final String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    public final String getAltAttribute() {
        return this.getAttribute("alt");
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getLongDescAttribute() {
        return this.getAttribute("longdesc");
    }

    public final String getHeightAttribute() {
        return this.getAttribute("height");
    }

    public final String getWidthAttribute() {
        return this.getAttribute("width");
    }

    public final String getUseMapAttribute() {
        return this.getAttribute("usemap");
    }

    public final String getIsmapAttribute() {
        return this.getAttribute("ismap");
    }

    public final String getAlignAttribute() {
        return this.getAttribute("align");
    }

    public final String getBorderAttribute() {
        return this.getAttribute("border");
    }

    public final String getHspaceAttribute() {
        return this.getAttribute("hspace");
    }

    public final String getVspaceAttribute() {
        return this.getAttribute("vspace");
    }

    public int getHeight() throws IOException {
        return this.getImageReader().getHeight(0);
    }

    public int getWidth() throws IOException {
        return this.getImageReader().getWidth(0);
    }

    public ImageReader getImageReader() throws IOException {
        this.readImageIfNeeded();
        return this.imageData_.getImageReader();
    }

    public WebResponse getWebResponse(boolean downloadIfNeeded) throws IOException {
        if (downloadIfNeeded) {
            this.downloadImageIfNeeded();
        }
        return this.imageWebResponse_;
    }

    private void downloadImageIfNeeded() throws IOException {
        if (!this.downloaded_) {
            String src = this.getSrcAttribute();
            if (!("".equals(src) || this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_BLANK_SRC_AS_EMPTY) && StringUtils.isBlank(src))) {
                HtmlPage page = (HtmlPage)this.getPage();
                WebClient webclient = page.getWebClient();
                URL url = page.getFullyQualifiedUrl(src);
                String accept = webclient.getBrowserVersion().getImgAcceptHeader();
                WebRequest request = new WebRequest(url, accept);
                request.setAdditionalHeader("Referer", page.getUrl().toExternalForm());
                this.imageWebResponse_ = webclient.loadWebResponse(request);
            }
            this.imageData_ = null;
            this.downloaded_ = true;
        }
    }

    private void readImageIfNeeded() throws IOException {
        this.downloadImageIfNeeded();
        if (this.imageData_ == null) {
            if (null == this.imageWebResponse_) {
                throw new IOException("No image response available (src=" + this.getSrcAttribute() + ")");
            }
            ImageInputStream iis = ImageIO.createImageInputStream(this.imageWebResponse_.getContentAsStream());
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                iis.close();
                throw new IOException("No image detected in response");
            }
            ImageReader imageReader = iter.next();
            imageReader.setInput(iis);
            this.imageData_ = new ImageData(imageReader);
            while (iter.hasNext()) {
                iter.next().dispose();
            }
        }
    }

    public Page click(int x, int y) throws IOException {
        this.lastClickX_ = x;
        this.lastClickY_ = y;
        return super.click();
    }

    public Page click() throws IOException {
        return this.click(0, 0);
    }

    @Override
    protected boolean doClickStateUpdate() throws IOException {
        HtmlAnchor anchor;
        if (this.getUseMapAttribute() != ATTRIBUTE_NOT_DEFINED) {
            String mapName = this.getUseMapAttribute().substring(1);
            HtmlElement doc = ((HtmlPage)this.getPage()).getDocumentElement();
            HtmlMap map = (HtmlMap)doc.getOneHtmlElementByAttribute("map", "name", mapName);
            for (DomElement element : map.getChildElements()) {
                HtmlArea area;
                if (!(element instanceof HtmlArea) || !(area = (HtmlArea)element).containsPoint(this.lastClickX_, this.lastClickY_)) continue;
                area.doClickStateUpdate();
                return false;
            }
        }
        if ((anchor = (HtmlAnchor)this.getEnclosingElement("a")) == null) {
            return false;
        }
        if (this.getIsmapAttribute() != ATTRIBUTE_NOT_DEFINED) {
            String suffix = "?" + this.lastClickX_ + "," + this.lastClickY_;
            anchor.doClickStateUpdate(suffix);
            return false;
        }
        anchor.doClickStateUpdate();
        return false;
    }

    public void saveAs(File file) throws IOException {
        ImageReader reader = this.getImageReader();
        ImageIO.write((RenderedImage)reader.read(0), reader.getFormatName(), file);
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }

    public boolean getComplete() {
        if (this.hasFeature(BrowserVersionFeatures.JS_IMAGE_COMPLETE_RETURNS_TRUE_FOR_NO_REQUEST)) {
            return this.downloaded_ || ATTRIBUTE_NOT_DEFINED == this.getSrcAttribute();
        }
        return this.imageData_ != null;
    }

    @Override
    public boolean isDisplayed() {
        String src = this.getSrcAttribute();
        if (this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_INVISIBLE_NO_SRC) && (ATTRIBUTE_NOT_DEFINED == src || this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_BLANK_SRC_AS_EMPTY) && StringUtils.isBlank(src))) {
            return false;
        }
        return super.isDisplayed();
    }

    public void markAsCreatedByJavascript() {
        this.createdByJavascript_ = true;
    }

    public boolean wasCreatedByJavascript() {
        return this.createdByJavascript_;
    }

    public String getOriginalQualifiedName() {
        return this.originalQualifiedName_;
    }

    @Override
    public String getLocalName() {
        if (this.wasCreatedByJavascript() && (this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLELEMENT) || this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLUNKNOWNELEMENT))) {
            return this.originalQualifiedName_;
        }
        return super.getLocalName();
    }

    private static final class ImageData {
        private final ImageReader imageReader_;

        ImageData(ImageReader imageReader) {
            this.imageReader_ = imageReader;
        }

        public ImageReader getImageReader() {
            return this.imageReader_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            if (this.imageReader_ != null) {
                try {
                    ImageInputStream stream = (ImageInputStream)this.imageReader_.getInput();
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), e);
                }
                finally {
                    this.imageReader_.setInput(null);
                    this.imageReader_.dispose();
                }
            }
            super.finalize();
        }
    }
}

