/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.FunctionWrapper;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.JavaScriptException;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
public class Promise
extends SimpleScriptable {
    private Object value_;

    public Promise() {
    }

    public Promise(Window window) {
        this.setParentScope(window);
        this.setPrototype(window.getPrototype(Promise.class));
    }

    @JsxConstructor
    public Promise(Object object) {
        if (object instanceof Promise) {
            this.value_ = ((Promise)object).value_;
        } else if (object instanceof NativeObject) {
            NativeObject nativeObject = (NativeObject)object;
            this.value_ = nativeObject.get("then", (Scriptable)nativeObject);
        } else {
            this.value_ = object;
        }
    }

    @JsxStaticFunction
    public static Promise resolve(Context context, Scriptable thisObj, Object[] args, Function function) {
        Promise promise = new Promise(args.length != 0 ? args[0] : Undefined.instance);
        promise.setParentScope(thisObj.getParentScope());
        promise.setPrototype(Promise.getWindow(thisObj).getPrototype(promise.getClass()));
        return promise;
    }

    @JsxFunction
    public Promise then(final Function onFulfilled, final Function onRejected) {
        final Window window = this.getWindow();
        final Promise promise = new Promise(window);
        final Promise thisPromise = this;
        PostponedAction thenAction = new PostponedAction(window.getDocument().getPage(), "Promise.then"){

            @Override
            public void execute() throws Exception {
                Object newValue;
                block5: {
                    newValue = null;
                    if (Promise.this.value_ instanceof Function) {
                        WasCalledFunctionWrapper wrapper = new WasCalledFunctionWrapper(onFulfilled);
                        try {
                            ((Function)Promise.this.value_).call(Context.getCurrentContext(), window, thisPromise, new Object[]{wrapper, onRejected});
                            if (wrapper.wasCalled_) {
                                newValue = wrapper.value_;
                            }
                            break block5;
                        }
                        catch (JavaScriptException e) {
                            if (!wrapper.wasCalled_) {
                                newValue = onRejected.call(Context.getCurrentContext(), window, thisPromise, new Object[]{e.getValue()});
                            }
                            break block5;
                        }
                    }
                    newValue = onFulfilled.call(Context.getCurrentContext(), window, thisPromise, new Object[]{Promise.this.value_});
                }
                promise.value_ = newValue;
            }
        };
        JavaScriptEngine jsEngine = window.getWebWindow().getWebClient().getJavaScriptEngine();
        jsEngine.addPostponedAction(thenAction);
        return promise;
    }

    private static class WasCalledFunctionWrapper
    extends FunctionWrapper {
        private boolean wasCalled_;
        private Object value_;

        WasCalledFunctionWrapper(Function wrapped) {
            super(wrapped);
        }

        @Override
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            this.wasCalled_ = true;
            this.value_ = super.call(cx, scope, thisObj, args);
            return this.value_;
        }
    }
}

