/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.AbstractJavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=38.0f), @WebBrowser(value=BrowserName.EDGE)})
public class Symbol
extends SimpleScriptable {
    static final String ITERATOR_STRING = "Symbol(Symbol.iterator)";
    private static Map<BrowserVersion, Map<String, Symbol>> SYMBOL_MAP_ = new HashMap<BrowserVersion, Map<String, Symbol>>();
    private Object name_;

    public Symbol() {
    }

    @JsxConstructor
    public Symbol(Object name) {
        this.name_ = name;
        for (StackTraceElement stackElements : new Throwable().getStackTrace()) {
            if (!stackElements.getClassName().contains("BaseFunction")) continue;
            throw ScriptRuntime.typeError("Symbol is not a constructor");
        }
    }

    @JsxStaticGetter
    public static Symbol getIterator(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "iterator");
    }

    private static Symbol getSymbol(Scriptable thisObj, String name) {
        Symbol symbol;
        SimpleScriptable scope = (SimpleScriptable)thisObj.getParentScope();
        BrowserVersion browserVersion = scope.getBrowserVersion();
        Map<String, Symbol> map = SYMBOL_MAP_.get(browserVersion);
        if (map == null) {
            map = new HashMap<String, Symbol>();
            SYMBOL_MAP_.put(browserVersion, map);
        }
        if ((symbol = map.get(name)) == null) {
            symbol = new Symbol(name);
            symbol.setParentScope(scope);
            symbol.setPrototype(scope.getPrototype(symbol.getClass()));
            map.put(name, symbol);
        }
        return symbol;
    }

    @JsxStaticGetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public static Symbol getUnscopables(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "unscopables");
    }

    @JsxStaticGetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public static Symbol getIsConcatSpreadable(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "isConcatSpreadable");
    }

    @JsxStaticGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=45.0f)})
    public static Symbol getToPrimitive(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "toPrimitive");
    }

    @JsxStaticGetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public static Symbol getToStringTag(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "toStringTag");
    }

    @JsxStaticGetter(value={@WebBrowser(value=BrowserName.FF, minVersion=45.0f)})
    public static Symbol getMatch(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "match");
    }

    @JsxStaticGetter(value={@WebBrowser(value=BrowserName.FF, minVersion=45.0f)})
    public static Symbol getSpecies(Scriptable thisObj) {
        return Symbol.getSymbol(thisObj, "species");
    }

    @JsxStaticFunction(functionName="for")
    public static Symbol forFunction(Context context, Scriptable thisObj, Object[] args, Function function) {
        String key = Context.toString(args.length != 0 ? args[0] : Undefined.instance);
        Symbol symbol = (Symbol)((ScriptableObject)thisObj).get(key);
        if (symbol == null) {
            SimpleScriptable parentScope = (SimpleScriptable)thisObj.getParentScope();
            symbol = new Symbol(key);
            symbol.setParentScope(parentScope);
            symbol.setPrototype(parentScope.getPrototype(symbol.getClass()));
            thisObj.put(key, thisObj, (Object)symbol);
        }
        return symbol;
    }

    @Override
    public String getTypeOf() {
        return "symbol";
    }

    @JsxFunction
    public String toString() {
        String name;
        if (this.name_ == Undefined.instance) {
            name = "";
        } else {
            name = Context.toString(this.name_);
            ClassConfiguration config = AbstractJavaScriptConfiguration.getClassConfiguration(this.getClass(), this.getBrowserVersion());
            for (Map.Entry<String, ClassConfiguration.PropertyInfo> propertyEntry : config.getStaticPropertyEntries()) {
                if (!propertyEntry.getKey().equals(name)) continue;
                name = "Symbol." + name;
                break;
            }
        }
        return "Symbol(" + name + ')';
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            return this.toString();
        }
        return super.getDefaultValue(hint);
    }
}

