/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.InteractivePage;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.WebSocketCookieStore;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.ArrayBuffer;
import com.gargoylesoftware.htmlunit.javascript.host.event.CloseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.event.MessageEvent;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.Future;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

@JsxClass
public class WebSocket
extends EventTarget
implements AutoCloseable {
    private static final Log LOG = LogFactory.getLog(WebSocket.class);
    @JsxConstant
    public static final int CONNECTING = 0;
    @JsxConstant
    public static final int OPEN = 1;
    @JsxConstant
    public static final int CLOSING = 2;
    @JsxConstant
    public static final int CLOSED = 3;
    private Function closeHandler_;
    private Function errorHandler_;
    private Function messageHandler_;
    private Function openHandler_;
    private URI url_;
    private int readyState_ = 0;
    private String binaryType_ = "blob";
    private HtmlPage containingPage_;
    private WebSocketClient client_;
    private volatile Session incomingSession_;
    private Session outgoingSession_;

    public WebSocket() {
    }

    private WebSocket(String url, Object protocols, Window window) {
        try {
            this.containingPage_ = (HtmlPage)window.getWebWindow().getEnclosedPage();
            this.setParentScope(window);
            this.setDomNode(this.containingPage_.getBody(), false);
            this.client_ = this.containingPage_.getWebClient().getOptions().isUseInsecureSSL() ? new WebSocketClient(new SslContextFactory(true)) : new WebSocketClient();
            this.client_.setCookieStore(new WebSocketCookieStore(window.getWebWindow().getWebClient()));
            this.client_.start();
            this.containingPage_.addAutoCloseable(this);
            this.url_ = new URI(url);
            final Future<Session> connectFuture = this.client_.connect(new WebSocketImpl(), this.url_, new ClientUpgradeRequest());
            this.client_.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        WebSocket.this.readyState_ = 0;
                        WebSocket.this.incomingSession_ = (Session)connectFuture.get();
                    }
                    catch (Exception e) {
                        LOG.error("WS connect error", e);
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error("WS constructor error", e);
        }
    }

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (args.length < 1 || args.length > 2) {
            throw Context.reportRuntimeError("WebSocket Error: constructor must have one or two String parameters.");
        }
        if (args[0] == Context.getUndefinedValue()) {
            throw Context.reportRuntimeError("WebSocket Error: 'url' parameter is undefined.");
        }
        if (!(args[0] instanceof String)) {
            throw Context.reportRuntimeError("WebSocket Error: 'url' parameter must be a String.");
        }
        return new WebSocket((String)args[0], null, WebSocket.getWindow(ctorObj));
    }

    @JsxGetter
    public Function getOnclose() {
        return this.closeHandler_;
    }

    @JsxSetter
    public void setOnclose(Function closeHandler) {
        this.closeHandler_ = closeHandler;
    }

    @JsxGetter
    public Function getOnerror() {
        return this.errorHandler_;
    }

    @JsxSetter
    public void setOnerror(Function errorHandler) {
        this.errorHandler_ = errorHandler;
    }

    @JsxGetter
    public Function getOnmessage() {
        return this.messageHandler_;
    }

    @JsxSetter
    public void setOnmessage(Function messageHandler) {
        this.messageHandler_ = messageHandler;
    }

    @JsxGetter
    public Function getOnopen() {
        return this.openHandler_;
    }

    @JsxSetter
    public void setOnopen(Function openHandler) {
        this.openHandler_ = openHandler;
    }

    @JsxGetter
    public int getReadyState() {
        return this.readyState_;
    }

    @JsxGetter
    public String getUrl() {
        return this.url_.toString();
    }

    @JsxGetter
    public String getProtocol() {
        return "";
    }

    @JsxGetter
    public long getBufferedAmount() {
        return 0L;
    }

    @JsxGetter
    public String getBinaryType() {
        return this.binaryType_;
    }

    @JsxSetter
    public void setBinaryType(String type) {
        if ("arraybuffer".equals(type) || "blob".equals(type)) {
            this.binaryType_ = type;
        }
    }

    @Override
    public void close() throws Exception {
        this.close(null, null);
    }

    @JsxFunction
    public void close(Object code, Object reason) {
        if (this.readyState_ != 3) {
            if (this.incomingSession_ != null) {
                this.incomingSession_.close();
            }
            if (this.outgoingSession_ != null) {
                this.outgoingSession_.close();
            }
        }
        try {
            if (this.client_ != null) {
                this.client_.stop();
                this.client_ = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @JsxFunction
    public void send(Object content) {
        block4: {
            try {
                if (content instanceof String) {
                    this.outgoingSession_.getRemote().sendString((String)content);
                    break block4;
                }
                if (content instanceof ArrayBuffer) {
                    byte[] bytes = ((ArrayBuffer)content).getBytes();
                    ByteBuffer buffer = ByteBuffer.wrap(bytes);
                    this.outgoingSession_.getRemote().sendBytes(buffer);
                    break block4;
                }
                throw new IllegalStateException("Not Yet Implemented: WebSocket.send() was used to send non-string value");
            }
            catch (IOException e) {
                LOG.error("WS send error", e);
            }
        }
    }

    private void fire(final Event evt) {
        evt.setTarget(this);
        evt.setParentScope(this.getParentScope());
        evt.setPrototype(this.getPrototype(evt.getClass()));
        JavaScriptEngine engine = this.containingPage_.getWebClient().getJavaScriptEngine();
        engine.getContextFactory().call(new ContextAction(){

            @Override
            public ScriptResult run(Context cx) {
                return WebSocket.this.executeEventLocally(evt);
            }
        });
    }

    private void callFunction(Function function, Object[] args) {
        if (function == null) {
            return;
        }
        Scriptable scope = function.getParentScope();
        JavaScriptEngine engine = this.containingPage_.getWebClient().getJavaScriptEngine();
        engine.callFunction((InteractivePage)this.containingPage_, function, scope, this, args);
    }

    private class WebSocketImpl
    extends WebSocketAdapter {
        private WebSocketImpl() {
        }

        @Override
        public void onWebSocketConnect(Session session) {
            super.onWebSocketConnect(session);
            WebSocket.this.readyState_ = 1;
            WebSocket.this.outgoingSession_ = session;
            Event openEvent = new Event();
            openEvent.setType("open");
            WebSocket.this.fire(openEvent);
            WebSocket.this.callFunction(WebSocket.this.openHandler_, ArrayUtils.EMPTY_OBJECT_ARRAY);
        }

        @Override
        public void onWebSocketClose(int statusCode, String reason) {
            super.onWebSocketClose(statusCode, reason);
            WebSocket.this.readyState_ = 3;
            WebSocket.this.outgoingSession_ = null;
            CloseEvent closeEvent = new CloseEvent();
            closeEvent.setCode(statusCode);
            closeEvent.setReason(reason);
            closeEvent.setWasClean(true);
            WebSocket.this.fire(closeEvent);
            WebSocket.this.callFunction(WebSocket.this.closeHandler_, new Object[]{closeEvent});
        }

        @Override
        public void onWebSocketText(String message) {
            super.onWebSocketText(message);
            MessageEvent msgEvent = new MessageEvent(message);
            msgEvent.setOrigin(WebSocket.this.getUrl());
            WebSocket.this.fire(msgEvent);
            WebSocket.this.callFunction(WebSocket.this.messageHandler_, new Object[]{msgEvent});
        }

        @Override
        public void onWebSocketBinary(byte[] data, int offset, int length) {
            super.onWebSocketBinary(data, offset, length);
            ArrayBuffer buffer = new ArrayBuffer();
            buffer.setParentScope(WebSocket.this.getParentScope());
            buffer.setPrototype(WebSocket.this.getPrototype(buffer.getClass()));
            buffer.constructor(length);
            buffer.setBytes(0, Arrays.copyOfRange(data, offset, length));
            MessageEvent msgEvent = new MessageEvent(buffer);
            msgEvent.setOrigin(WebSocket.this.getUrl());
            WebSocket.this.fire(msgEvent);
            WebSocket.this.callFunction(WebSocket.this.messageHandler_, new Object[]{msgEvent});
        }
    }
}

