/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering;

import com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering.RenderingBackend;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AwtRenderingBackend
implements RenderingBackend {
    private static final Log LOG = LogFactory.getLog(AwtRenderingBackend.class);
    private final BufferedImage image_;
    private final Graphics2D graphics2D_;

    public AwtRenderingBackend(int imageWidth, int imageHeight) {
        this.image_ = new BufferedImage(imageWidth, imageHeight, 1);
        this.graphics2D_ = this.image_.createGraphics();
    }

    @Override
    public void setFillStyle(String fillStyle) {
        String tmpFillStyle = fillStyle.replaceAll("\\s", "");
        Color color = null;
        if (tmpFillStyle.startsWith("rgb(")) {
            String[] colors = tmpFillStyle.substring(4, tmpFillStyle.length() - 1).split(",");
            color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
        } else if (tmpFillStyle.startsWith("rgba(")) {
            String[] colors = tmpFillStyle.substring(5, tmpFillStyle.length() - 1).split(",");
            color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]), (int)(Float.parseFloat(colors[3]) * 255.0f));
        } else if (tmpFillStyle.startsWith("#")) {
            color = Color.decode(tmpFillStyle);
        } else {
            try {
                Field f = Color.class.getField(tmpFillStyle);
                color = (Color)f.get(null);
            }
            catch (Exception e) {
                LOG.info("Can not find color '" + tmpFillStyle + '\'');
                color = Color.black;
            }
        }
        this.graphics2D_.setColor(color);
    }

    @Override
    public void fillRect(int x, int y, int w, int h) {
        this.graphics2D_.fillRect(x, y, w, h);
    }

    @Override
    public void drawImage(ImageReader imageReader, int dxI, int dyI) throws IOException {
        if (imageReader.getNumImages(true) != 0) {
            BufferedImage img = imageReader.read(0);
            this.graphics2D_.drawImage((Image)img, dxI, dyI, null);
        }
    }

    @Override
    public byte[] getBytes(int width, int height, int sx, int sy) {
        byte[] array = new byte[width * height * 4];
        int index = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                Color c = new Color(this.image_.getRGB(sx + x, sy + y), true);
                array[index++] = (byte)c.getRed();
                array[index++] = (byte)c.getGreen();
                array[index++] = (byte)c.getBlue();
                array[index++] = (byte)c.getAlpha();
            }
        }
        return array;
    }

    @Override
    public String encodeToString(String type) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)this.image_, type, bos);
            byte[] imageBytes = bos.toByteArray();
            String string = new String(new Base64().encode(imageBytes));
            return string;
        }
    }
}

