/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.dom.CharacterData;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMException;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.dom.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLHtmlElement;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Interpreter;
import net.sourceforge.htmlunit.corejs.javascript.JavaScriptException;
import net.sourceforge.htmlunit.corejs.javascript.RhinoException;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

@JsxClass
public class Node
extends EventTarget {
    @JsxConstant
    public static final short ELEMENT_NODE = 1;
    @JsxConstant
    public static final short ATTRIBUTE_NODE = 2;
    @JsxConstant
    public static final short TEXT_NODE = 3;
    @JsxConstant
    public static final short CDATA_SECTION_NODE = 4;
    @JsxConstant
    public static final short ENTITY_REFERENCE_NODE = 5;
    @JsxConstant
    public static final short ENTITY_NODE = 6;
    @JsxConstant
    public static final short PROCESSING_INSTRUCTION_NODE = 7;
    @JsxConstant
    public static final short COMMENT_NODE = 8;
    @JsxConstant
    public static final short DOCUMENT_NODE = 9;
    @JsxConstant
    public static final short DOCUMENT_TYPE_NODE = 10;
    @JsxConstant
    public static final short DOCUMENT_FRAGMENT_NODE = 11;
    @JsxConstant
    public static final short NOTATION_NODE = 12;
    @JsxConstant
    public static final short DOCUMENT_POSITION_DISCONNECTED = 1;
    @JsxConstant
    public static final short DOCUMENT_POSITION_PRECEDING = 2;
    @JsxConstant
    public static final short DOCUMENT_POSITION_FOLLOWING = 4;
    @JsxConstant
    public static final short DOCUMENT_POSITION_CONTAINS = 8;
    @JsxConstant
    public static final short DOCUMENT_POSITION_CONTAINED_BY = 16;
    @JsxConstant
    public static final short DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;
    private NodeList childNodes_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public Node() {
    }

    @JsxGetter
    public short getNodeType() {
        return this.getDomNodeOrDie().getNodeType();
    }

    @JsxGetter
    public String getNodeName() {
        return this.getDomNodeOrDie().getNodeName();
    }

    @JsxGetter
    public String getNodeValue() {
        return this.getDomNodeOrDie().getNodeValue();
    }

    @JsxSetter
    public void setNodeValue(String newValue) {
        this.getDomNodeOrDie().setNodeValue(newValue);
    }

    @JsxFunction
    public Object appendChild(Object childObject) {
        Object appendedChild = null;
        if (childObject instanceof Node) {
            Node childNode = (Node)childObject;
            if (!Node.isNodeInsertable(childNode)) {
                throw this.asJavaScriptException(new DOMException("Node cannot be inserted at the specified point in the hierarchy", 3));
            }
            DomNode childDomNode = childNode.getDomNodeOrDie();
            DomNode parentNode = this.getDomNodeOrDie();
            parentNode.appendChild(childDomNode);
            appendedChild = childObject;
            Node.initInlineFrameIfNeeded(childDomNode);
            for (DomNode domNode : childDomNode.getDescendants()) {
                Node.initInlineFrameIfNeeded(domNode);
            }
        }
        return appendedChild;
    }

    private static void initInlineFrameIfNeeded(DomNode childDomNode) {
        HtmlInlineFrame frame;
        if (childDomNode instanceof HtmlInlineFrame && DomElement.ATTRIBUTE_NOT_DEFINED == (frame = (HtmlInlineFrame)childDomNode).getSrcAttribute()) {
            frame.loadInnerPage();
        }
    }

    protected RhinoException asJavaScriptException(DOMException exception) {
        exception.setPrototype(this.getWindow().getPrototype(exception.getClass()));
        exception.setParentScope(this.getWindow());
        if (Context.getCurrentContext().getOptimizationLevel() != -1) {
            throw new Error("HtmlUnit not ready to run in compiled mode");
        }
        int[] linep = new int[1];
        String sourceName = new Interpreter().getSourcePositionFromStack(Context.getCurrentContext(), linep);
        String fileName = sourceName.replaceFirst("script in (.*) from .*", "$1");
        int lineNumber = linep[0];
        exception.setLocation(fileName, lineNumber);
        return new JavaScriptException(exception, fileName, lineNumber);
    }

    @JsxFunction
    public static Object insertBefore(Context context, Scriptable thisObj, Object[] args, Function function) {
        return ((Node)thisObj).insertBeforeImpl(args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object insertBeforeImpl(Object[] args) {
        DomNode refChildNode;
        Object newChildObject = args[0];
        Object refChildObject = args.length > 1 ? args[1] : Undefined.instance;
        Node insertedChild = null;
        if (!(newChildObject instanceof Node)) return insertedChild;
        Node newChild = (Node)newChildObject;
        DomNode newChildNode = newChild.getDomNodeOrDie();
        if (!Node.isNodeInsertable(newChild)) {
            throw this.asJavaScriptException(new DOMException("Node cannot be inserted at the specified point in the hierarchy", 3));
        }
        if (newChildNode instanceof DomDocumentFragment) {
            DomDocumentFragment fragment = (DomDocumentFragment)newChildNode;
            for (DomNode child : fragment.getChildren()) {
                if (Node.isNodeInsertable((Node)child.getScriptableObject())) continue;
                throw this.asJavaScriptException(new DOMException("Node cannot be inserted at the specified point in the hierarchy", 3));
            }
        }
        if (refChildObject == Undefined.instance) {
            if (args.length != 2) {
                if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_NODE_INSERT_BEFORE_REF_OPTIONAL)) throw Context.reportRuntimeError("insertBefore: not enough arguments");
            }
            refChildNode = null;
        } else {
            refChildNode = refChildObject != null ? ((Node)refChildObject).getDomNodeOrDie() : null;
        }
        DomNode domNode = this.getDomNodeOrDie();
        try {
            domNode.insertBefore(newChildNode, refChildNode);
            return newChild;
        }
        catch (org.w3c.dom.DOMException e) {
            throw this.asJavaScriptException(new DOMException(e.getMessage(), 3));
        }
    }

    private static boolean isNodeInsertable(Node childObject) {
        if (childObject instanceof HTMLHtmlElement) {
            DomNode domNode = childObject.getDomNodeOrDie();
            return domNode.getPage().getDocumentElement() != domNode;
        }
        return true;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.EDGE)})
    public void remove() {
        this.getDomNodeOrDie().remove();
    }

    @JsxFunction
    public Object removeChild(Object childObject) {
        if (!(childObject instanceof Node)) {
            return null;
        }
        DomNode childNode = ((Node)childObject).getDomNodeOrDie();
        if (!this.getDomNodeOrDie().isAncestorOf(childNode)) {
            Context.throwAsScriptRuntimeEx(new Exception("NotFoundError: Failed to execute 'removeChild' on '" + this + "': The node to be removed is not a child of this node."));
        }
        childNode.remove();
        return childObject;
    }

    @JsxFunction
    public Object replaceChild(Object newChildObject, Object oldChildObject) {
        Object removedChild = null;
        if (newChildObject instanceof DocumentFragment) {
            DocumentFragment fragment = (DocumentFragment)newChildObject;
            Node firstNode = null;
            Node refChildObject = ((Node)oldChildObject).getNextSibling();
            for (DomNode node : fragment.getDomNodeOrDie().getChildren()) {
                if (firstNode == null) {
                    this.replaceChild(node.getScriptableObject(), oldChildObject);
                    firstNode = (Node)node.getScriptableObject();
                    continue;
                }
                this.insertBeforeImpl(new Object[]{node.getScriptableObject(), refChildObject});
            }
            if (firstNode == null) {
                this.removeChild(oldChildObject);
            }
            removedChild = oldChildObject;
        } else if (newChildObject instanceof Node && oldChildObject instanceof Node) {
            Node newChild = (Node)newChildObject;
            if (!Node.isNodeInsertable(newChild)) {
                throw Context.reportRuntimeError("Node cannot be inserted at the specified point in the hierarchy");
            }
            DomNode newChildNode = newChild.getDomNodeOrDie();
            DomNode oldChildNode = ((Node)oldChildObject).getDomNodeOrDie();
            oldChildNode.replace(newChildNode);
            removedChild = oldChildObject;
        }
        return removedChild;
    }

    @JsxFunction
    public Object cloneNode(boolean deep) {
        DomNode domNode = this.getDomNodeOrDie();
        DomNode clonedNode = domNode.cloneNode(deep);
        Node jsClonedNode = this.getJavaScriptNode(clonedNode);
        return jsClonedNode;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE)})
    public boolean isSameNode(Object other) {
        return other == this;
    }

    @JsxFunction
    public boolean hasChildNodes() {
        return this.getDomNodeOrDie().getChildren().iterator().hasNext();
    }

    @JsxGetter
    public NodeList getChildNodes() {
        if (this.childNodes_ == null) {
            final DomNode node = this.getDomNodeOrDie();
            this.childNodes_ = new NodeList(node, false){

                @Override
                protected List<Object> computeElements() {
                    ArrayList<Object> response = new ArrayList<Object>();
                    for (DomNode child : node.getChildren()) {
                        response.add(child);
                    }
                    return response;
                }
            };
        }
        return this.childNodes_;
    }

    public Node getParent() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getParentNode());
    }

    @JsxGetter
    public Object getParentNode() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getParentNode());
    }

    @JsxGetter
    public Node getNextSibling() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getNextSibling());
    }

    @JsxGetter
    public Node getPreviousSibling() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getPreviousSibling());
    }

    @JsxGetter
    public Node getFirstChild() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getFirstChild());
    }

    @JsxGetter
    public Node getLastChild() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getLastChild());
    }

    protected Node getJavaScriptNode(DomNode domNode) {
        if (domNode == null) {
            return null;
        }
        return (Node)this.getScriptableFor(domNode);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void detachEvent(String type, Function listener) {
        this.removeEventListener(StringUtils.substring(type, 2), listener, false);
    }

    @JsxGetter
    public Object getOwnerDocument() {
        Document document = this.getDomNodeOrDie().getOwnerDocument();
        if (document == null) {
            return null;
        }
        return ((SgmlPage)document).getScriptableObject();
    }

    @JsxGetter
    public Object getPrefix() {
        DomNode domNode = this.getDomNodeOrDie();
        return domNode.getPrefix();
    }

    @JsxGetter
    public Object getLocalName() {
        return this.getDomNodeOrDie().getLocalName();
    }

    @JsxGetter
    public Object getNamespaceURI() {
        return this.getDomNodeOrDie().getNamespaceURI();
    }

    @JsxFunction
    public short compareDocumentPosition(Object node) {
        if (!(node instanceof Node)) {
            throw Context.reportRuntimeError("Could not convert JavaScript argument arg 0");
        }
        return this.getDomNodeOrDie().compareDocumentPosition(((Node)node).getDomNodeOrDie());
    }

    @JsxFunction
    public void normalize() {
        this.getDomNodeOrDie().normalize();
    }

    @JsxGetter
    public String getTextContent() {
        return this.getDomNodeOrDie().getTextContent();
    }

    @JsxSetter
    public void setTextContent(Object value) {
        this.getDomNodeOrDie().setTextContent(value == null ? null : Context.toString(value));
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public Element getParentElement() {
        Node parent = this.getParent();
        if (!(parent instanceof Element)) {
            return null;
        }
        return (Element)parent;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF, maxVersion=21.0f)})
    public Object getAttributes() {
        return null;
    }

    @JsxFunction
    public boolean contains(Object element) {
        if (!(element instanceof Node)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_NODE_CONTAINS_RETURNS_FALSE_FOR_INVALID_ARG)) {
                return false;
            }
            throw Context.reportRuntimeError("Could not convert JavaScript argument arg 0");
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_NODE_CONTAINS_RETURNS_FALSE_FOR_INVALID_ARG)) {
            if (element instanceof CharacterData) {
                return false;
            }
            if (this instanceof CharacterData) {
                throw Context.reportRuntimeError("Function 'contains' not available for text nodes.");
            }
        }
        for (Node parent = (Node)element; parent != null; parent = parent.getParentElement()) {
            if (this != parent) continue;
            return true;
        }
        return false;
    }
}

