/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import java.lang.reflect.Method;
import java.util.LinkedList;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClass
public class Event
extends SimpleScriptable {
    protected static final String KEY_CURRENT_EVENT = "Event#current";
    public static final String TYPE_SUBMIT = "submit";
    public static final String TYPE_CHANGE = "change";
    public static final String TYPE_LOAD = "load";
    public static final String TYPE_UNLOAD = "unload";
    public static final String TYPE_POPSTATE = "popstate";
    public static final String TYPE_FOCUS = "focus";
    public static final String TYPE_FOCUS_IN = "focusin";
    public static final String TYPE_FOCUS_OUT = "focusout";
    public static final String TYPE_BLUR = "blur";
    public static final String TYPE_KEY_DOWN = "keydown";
    public static final String TYPE_KEY_PRESS = "keypress";
    public static final String TYPE_INPUT = "input";
    public static final String TYPE_KEY_UP = "keyup";
    public static final String TYPE_RESET = "reset";
    public static final String TYPE_BEFORE_UNLOAD = "beforeunload";
    public static final String TYPE_DOM_DOCUMENT_LOADED = "DOMContentLoaded";
    public static final String TYPE_PROPERTY_CHANGE = "propertychange";
    public static final String TYPE_HASH_CHANGE = "hashchange";
    public static final String TYPE_READY_STATE_CHANGE = "readystatechange";
    public static final String TYPE_ERROR = "error";
    public static final String TYPE_MESSAGE = "message";
    public static final String TYPE_CLOSE = "close";
    public static final String TYPE_OPEN = "open";
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public static final short NONE = 0;
    @JsxConstant
    public static final short CAPTURING_PHASE = 1;
    @JsxConstant
    public static final short AT_TARGET = 2;
    @JsxConstant
    public static final short BUBBLING_PHASE = 3;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int BLUR = 8192;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int CHANGE = 32768;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int CLICK = 64;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int DBLCLICK = 128;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int DRAGDROP = 2048;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int FOCUS = 4096;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int KEYDOWN = 256;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int KEYPRESS = 1024;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int KEYUP = 512;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int MOUSEDOWN = 1;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int MOUSEDRAG = 32;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int MOUSEMOVE = 16;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int MOUSEOUT = 8;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int MOUSEOVER = 4;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int MOUSEUP = 2;
    @JsxConstant(value={@WebBrowser(value=BrowserName.CHROME)})
    public static final int SELECT = 16384;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int ALT_MASK = 1;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int CONTROL_MASK = 2;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int SHIFT_MASK = 4;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int META_MASK = 8;
    private Object srcElement_;
    private Object target_;
    private Scriptable currentTarget_;
    private String type_ = "";
    private Object keyCode_;
    private boolean shiftKey_;
    private boolean ctrlKey_;
    private boolean altKey_;
    private String propertyName_;
    private boolean stopPropagation_;
    private Object returnValue_;
    private boolean preventDefault_;
    private short eventPhase_;
    private boolean bubbles_ = true;
    private boolean cancelable_ = true;
    private final long timeStamp_ = System.currentTimeMillis();

    public Event(DomNode domNode, String type) {
        this((SimpleScriptable)domNode.getScriptableObject(), type);
        this.setDomNode(domNode, false);
    }

    public Event(SimpleScriptable scriptable, String type) {
        this.srcElement_ = scriptable;
        this.target_ = scriptable;
        this.currentTarget_ = scriptable;
        this.type_ = type;
        this.setParentScope(scriptable);
        this.setPrototype(this.getPrototype(this.getClass()));
        if (TYPE_CHANGE.equals(type)) {
            this.cancelable_ = false;
        } else if (TYPE_LOAD.equals(type)) {
            this.bubbles_ = false;
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONLOAD_CANCELABLE_FALSE)) {
                this.cancelable_ = false;
            }
        }
    }

    public static Event createPropertyChangeEvent(DomNode domNode, String propertyName) {
        Event event = new Event(domNode, TYPE_PROPERTY_CHANGE);
        event.propertyName_ = propertyName;
        return event;
    }

    public Event() {
    }

    public void eventCreated() {
        this.setBubbles(false);
        this.setCancelable(false);
    }

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public void jsConstructor(String type, ScriptableObject details) {
        boolean bubbles = false;
        boolean cancelable = false;
        if (details != null && !Context.getUndefinedValue().equals(details)) {
            Boolean detailCancelable;
            Boolean detailBubbles = (Boolean)details.get("bubbles");
            if (detailBubbles != null) {
                bubbles = detailBubbles;
            }
            if ((detailCancelable = (Boolean)details.get("cancelable")) != null) {
                cancelable = detailCancelable;
            }
        }
        this.initEvent(type, bubbles, cancelable);
    }

    public void startFire() {
        Context context = Context.getCurrentContext();
        LinkedList<Event> events = (LinkedList<Event>)context.getThreadLocal(KEY_CURRENT_EVENT);
        if (events == null) {
            events = new LinkedList<Event>();
            context.putThreadLocal(KEY_CURRENT_EVENT, events);
        }
        events.add(this);
    }

    public void endFire() {
        ((LinkedList)Context.getCurrentContext().getThreadLocal(KEY_CURRENT_EVENT)).removeLast();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.EDGE)})
    public Object getSrcElement() {
        return this.srcElement_;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setSrcElement(Object srcElement) {
        this.srcElement_ = srcElement;
    }

    @JsxGetter
    public Object getTarget() {
        return this.target_;
    }

    public void setTarget(Object target) {
        this.target_ = target;
    }

    @JsxGetter
    public Scriptable getCurrentTarget() {
        return this.currentTarget_;
    }

    public void setCurrentTarget(Scriptable target) {
        this.currentTarget_ = target;
    }

    @JsxGetter
    public String getType() {
        return this.type_;
    }

    @JsxSetter
    public void setType(String type) {
        this.type_ = type;
    }

    public void setEventType(String eventType) {
        this.type_ = eventType;
    }

    @JsxGetter
    public long getTimeStamp() {
        return this.timeStamp_;
    }

    protected void setKeyCode(Object keyCode) {
        this.keyCode_ = keyCode;
    }

    public Object getKeyCode() {
        if (this.keyCode_ == null) {
            return 0;
        }
        return this.keyCode_;
    }

    public boolean getShiftKey() {
        return this.shiftKey_;
    }

    protected void setShiftKey(boolean shiftKey) {
        this.shiftKey_ = shiftKey;
    }

    public boolean getCtrlKey() {
        return this.ctrlKey_;
    }

    protected void setCtrlKey(boolean ctrlKey) {
        this.ctrlKey_ = ctrlKey;
    }

    public boolean getAltKey() {
        return this.altKey_;
    }

    protected void setAltKey(boolean altKey) {
        this.altKey_ = altKey;
    }

    @JsxGetter
    public int getEventPhase() {
        return this.eventPhase_;
    }

    public void setEventPhase(short phase) {
        if (phase != 1 && phase != 2 && phase != 3) {
            throw new IllegalArgumentException("Illegal phase specified: " + phase);
        }
        this.eventPhase_ = phase;
    }

    @JsxGetter
    public boolean getBubbles() {
        return this.bubbles_;
    }

    protected void setBubbles(boolean bubbles) {
        this.bubbles_ = bubbles;
    }

    @JsxGetter
    public boolean getCancelable() {
        return this.cancelable_;
    }

    protected void setCancelable(boolean cancelable) {
        this.cancelable_ = cancelable;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.EDGE)})
    public boolean getDefaultPrevented() {
        return this.cancelable_ && this.preventDefault_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getCancelBubble() {
        return this.stopPropagation_;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setCancelBubble(boolean newValue) {
        this.stopPropagation_ = newValue;
    }

    @JsxFunction
    public void stopPropagation() {
        this.stopPropagation_ = true;
    }

    public boolean isPropagationStopped() {
        return this.stopPropagation_;
    }

    public Object getReturnValue() {
        return this.returnValue_;
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue_ = returnValue;
    }

    public String getPropertyName() {
        return this.propertyName_;
    }

    @JsxFunction
    public void initEvent(String type, boolean bubbles, boolean cancelable) {
        this.type_ = type;
        this.bubbles_ = bubbles;
        this.cancelable_ = cancelable;
        if (TYPE_BEFORE_UNLOAD.equals(type) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_FOCUS_FOCUS_IN_BLUR_OUT)) {
            try {
                Method readMethod = this.getClass().getMethod("getReturnValue", new Class[0]);
                Method writeMethod = this.getClass().getMethod("setReturnValue", Object.class);
                this.defineProperty("returnValue", null, readMethod, writeMethod, 0);
                if ("Event".equals(this.getClass().getSimpleName())) {
                    this.setReturnValue(Boolean.TRUE);
                }
            }
            catch (Exception e) {
                throw Context.throwAsScriptRuntimeEx(e);
            }
        }
    }

    @JsxFunction
    public void preventDefault() {
        this.preventDefault_ = true;
    }

    public boolean isAborted(ScriptResult result) {
        return ScriptResult.isFalse(result) || this.preventDefault_;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("Event ");
        buffer.append(this.getType());
        buffer.append(" (");
        buffer.append("Current Target: ");
        buffer.append(this.currentTarget_);
        buffer.append(");");
        return buffer.toString();
    }
}

