/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.WindowProxy;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class MessageEvent
extends Event {
    private Object data_;
    private String origin_;
    private String lastEventId_;
    private Window source_;
    private Object ports_;

    public MessageEvent() {
        this.setType("message");
        this.origin_ = "";
        this.lastEventId_ = "";
        this.data_ = Undefined.instance;
    }

    public MessageEvent(Object data) {
        this();
        this.data_ = data;
    }

    @Override
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public void jsConstructor(String type, ScriptableObject details) {
        super.jsConstructor(type, details);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONMESSAGE_DEFAULT_DATA_NULL)) {
            this.data_ = null;
        }
        String origin = "";
        String lastEventId = "";
        if (details != null && !Context.getUndefinedValue().equals(details)) {
            Object detailLastEventId;
            this.data_ = details.get("data");
            String detailOrigin = (String)details.get("origin");
            if (detailOrigin != null) {
                origin = detailOrigin;
            }
            if ((detailLastEventId = details.get("lastEventId")) != null) {
                lastEventId = Context.toString(detailLastEventId);
            }
            this.source_ = null;
            Object detailSource = details.get("source");
            if (detailSource instanceof Window) {
                this.source_ = (Window)detailSource;
            } else if (detailSource instanceof WindowProxy) {
                this.source_ = ((WindowProxy)detailSource).getDelegee();
            }
            this.ports_ = details.get("ports");
        }
        this.origin_ = origin;
        this.lastEventId_ = lastEventId;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF, minVersion=45.0f)})
    public void initMessageEvent(String type, boolean canBubble, boolean cancelable, Object data, String origin, String lastEventId, Window source, Object ports) {
        this.initEvent(type, canBubble, cancelable);
        this.data_ = data;
        this.origin_ = origin;
        this.lastEventId_ = lastEventId;
        this.source_ = source;
        this.ports_ = ports;
    }

    @JsxGetter
    public Object getData() {
        return this.data_;
    }

    @JsxGetter
    public String getOrigin() {
        return this.origin_;
    }

    public void setOrigin(String origin) {
        this.origin_ = origin;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public String getLastEventId() {
        return this.lastEventId_;
    }

    @JsxGetter
    public Window getSource() {
        return this.source_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF, minVersion=45.0f)})
    public Object getPorts() {
        return this.ports_;
    }
}

