/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableComponent;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(domClass=HtmlTableRow.class)
public class HTMLTableRowElement
extends HTMLTableComponent {
    private HTMLCollection cells_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLTableRowElement() {
    }

    @JsxGetter
    public int getRowIndex() {
        HtmlTableRow row = (HtmlTableRow)this.getDomNodeOrDie();
        HtmlTable table = row.getEnclosingTable();
        if (table == null) {
            return -1;
        }
        return table.getRows().indexOf(row);
    }

    @JsxGetter
    public int getSectionRowIndex() {
        DomNode row = this.getDomNodeOrDie();
        HtmlTable table = ((HtmlTableRow)row).getEnclosingTable();
        if (table == null) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_TEXT_READONLY_FOR_TABLE)) {
                return 0;
            }
            return -1;
        }
        int index = -1;
        while (row != null) {
            if (row instanceof HtmlTableRow) {
                ++index;
            }
            row = row.getPreviousSibling();
        }
        return index;
    }

    @JsxGetter
    public Object getCells() {
        if (this.cells_ == null) {
            final HtmlTableRow row = (HtmlTableRow)this.getDomNodeOrDie();
            this.cells_ = new HTMLCollection(row, false){

                @Override
                protected List<Object> computeElements() {
                    return new ArrayList<Object>(row.getCells());
                }
            };
        }
        return this.cells_;
    }

    @JsxGetter
    public String getBgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    @JsxSetter
    public void setBgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    @JsxFunction
    public Object insertCell(Object index) {
        boolean indexValid;
        int position = -1;
        if (index != Undefined.instance) {
            position = (int)Context.toNumber(index);
        }
        HtmlTableRow htmlRow = (HtmlTableRow)this.getDomNodeOrDie();
        boolean bl = indexValid = position >= -1 && position <= htmlRow.getCells().size();
        if (indexValid) {
            DomElement newCell = ((HtmlPage)htmlRow.getPage()).createElement("td");
            if (position == -1 || position == htmlRow.getCells().size()) {
                htmlRow.appendChild(newCell);
            } else {
                htmlRow.getCell(position).insertBefore(newCell);
            }
            return this.getScriptableFor(newCell);
        }
        throw Context.reportRuntimeError("Index or size is negative or greater than the allowed amount");
    }

    @JsxFunction
    public void deleteCell(Object index) {
        boolean indexValid;
        int position = -1;
        if (index != Undefined.instance) {
            position = (int)Context.toNumber(index);
        } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TABLE_ROW_DELETE_CELL_REQUIRES_INDEX)) {
            throw Context.reportRuntimeError("No enough arguments");
        }
        HtmlTableRow htmlRow = (HtmlTableRow)this.getDomNodeOrDie();
        if (position == -1) {
            position = htmlRow.getCells().size() - 1;
        }
        boolean bl = indexValid = position >= -1 && position <= htmlRow.getCells().size();
        if (!indexValid) {
            throw Context.reportRuntimeError("Index or size is negative or greater than the allowed amount");
        }
        htmlRow.getCell(position).remove();
    }

    @Override
    @JsxSetter
    public void setOuterHTML(Object value) {
        throw Context.reportRuntimeError("outerHTML is read-only for tag 'tr'");
    }

    @Override
    @JsxSetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public void setInnerText(Object value) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_TEXT_READONLY_FOR_TABLE)) {
            throw Context.reportRuntimeError("innerText is read-only for tag 'tr'");
        }
        super.setInnerText(value);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getBorderColor() {
        return this.getDomNodeOrDie().getAttribute("borderColor");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setBorderColor(String borderColor) {
        this.setColorAttribute("borderColor", borderColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getBorderColorDark() {
        return this.getDomNodeOrDie().getAttribute("borderColorDark");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setBorderColorDark(String borderColor) {
        this.setColorAttribute("borderColorDark", borderColor);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getBorderColorLight() {
        return this.getDomNodeOrDie().getAttribute("borderColorLight");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setBorderColorLight(String borderColor) {
        this.setColorAttribute("borderColorLight", borderColor);
    }
}

