/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.AbstractCSSRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.format.CSSFormat;
import com.steadystate.css.format.CSSFormatable;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.util.LangUtils;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;

public class CSSStyleRuleImpl
extends AbstractCSSRuleImpl
implements CSSStyleRule {
    private static final long serialVersionUID = -697009251364657426L;
    private SelectorList selectors_;
    private CSSStyleDeclaration style_;

    public SelectorList getSelectors() {
        return this.selectors_;
    }

    public void setSelectors(SelectorList selectors) {
        this.selectors_ = selectors;
    }

    public CSSStyleRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, SelectorList selectors) {
        super(parentStyleSheet, parentRule);
        this.selectors_ = selectors;
    }

    public CSSStyleRuleImpl() {
    }

    public short getType() {
        return 1;
    }

    public String getCssText(CSSFormat format) {
        CSSStyleDeclaration style = this.getStyle();
        if (null == style) {
            return "";
        }
        String styleText = ((CSSFormatable)((Object)style)).getCssText(format);
        String selectorText = ((CSSFormatable)((Object)this.selectors_)).getCssText(format);
        if (null == styleText || styleText.length() == 0) {
            return selectorText + " { }";
        }
        return selectorText + " { " + styleText + " }";
    }

    public void setCssText(String cssText) throws DOMException {
        CSSStyleSheetImpl parentStyleSheet = this.getParentStyleSheetImpl();
        if (parentStyleSheet != null && parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 1) {
                throw new DOMExceptionImpl(13, 4);
            }
            this.selectors_ = ((CSSStyleRuleImpl)r).selectors_;
            this.style_ = ((CSSStyleRuleImpl)r).style_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public String getSelectorText() {
        return this.selectors_.toString();
    }

    public void setSelectorText(String selectorText) throws DOMException {
        CSSStyleSheetImpl parentStyleSheet = this.getParentStyleSheetImpl();
        if (parentStyleSheet != null && parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(selectorText));
            CSSOMParser parser = new CSSOMParser();
            this.selectors_ = parser.parseSelectors(is);
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public CSSStyleDeclaration getStyle() {
        return this.style_;
    }

    public void setStyle(CSSStyleDeclaration style) {
        this.style_ = style;
    }

    public String toString() {
        return this.getCssText();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSStyleRule)) {
            return false;
        }
        CSSStyleRule csr = (CSSStyleRule)obj;
        return super.equals(obj) && LangUtils.equals(this.getSelectorText(), csr.getSelectorText()) && LangUtils.equals(this.getStyle(), csr.getStyle());
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.selectors_);
        hash = LangUtils.hashCode(hash, this.style_);
        return hash;
    }
}

