/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.beta;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.utils.configuration.GridHubConfiguration;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.grid.web.servlet.beta.WebProxyHtmlRendererBeta;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ConsoleServlet
extends RegistryBasedServlet {
    private static final long serialVersionUID = 8484071790930378855L;
    private static final Logger log = Logger.getLogger(ConsoleServlet.class.getName());
    private static String coreVersion;

    public ConsoleServlet() {
        this(null);
    }

    public ConsoleServlet(Registry registry) {
        super(registry);
        this.getVersion();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int i;
        int refresh = -1;
        if (request.getParameter("refresh") != null) {
            try {
                refresh = Integer.parseInt(request.getParameter("refresh"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append("<head>");
        builder.append("<script src='//ajax.googleapis.com/ajax/libs/jquery/1.6.1/jquery.min.js'></script>");
        builder.append("<script src='/grid/resources/org/openqa/grid/images/console-beta.js'></script>");
        builder.append("<link href='/grid/resources/org/openqa/grid/images/console-beta.css' rel='stylesheet' type='text/css' />");
        builder.append("<link href='/grid/resources/org/openqa/grid/images/favicon.ico' rel='icon' type='image/x-icon' />");
        if (refresh != -1) {
            builder.append(String.format("<meta http-equiv='refresh' content='%d' />", refresh));
        }
        builder.append("<title>Grid Console</title>");
        builder.append("<style>");
        builder.append(".busy {");
        builder.append(" opacity : 0.4;");
        builder.append("filter: alpha(opacity=40);");
        builder.append("}");
        builder.append("</style>");
        builder.append("</head>");
        builder.append("<body>");
        builder.append("<div id='main_content'>");
        builder.append(this.getHeader());
        ArrayList<String> nodes = new ArrayList<String>();
        for (RemoteProxy proxy : this.getRegistry().getAllProxies()) {
            WebProxyHtmlRendererBeta beta = new WebProxyHtmlRendererBeta(proxy);
            nodes.add(beta.renderSummary());
        }
        int size = nodes.size();
        int rightColumnSize = size / 2;
        int leftColumnSize = size - rightColumnSize;
        builder.append("<div id='leftColumn'>");
        for (i = 0; i < leftColumnSize; ++i) {
            builder.append((String)nodes.get(i));
        }
        builder.append("</div>");
        builder.append("<div id='rightColumn'>");
        for (i = leftColumnSize; i < nodes.size(); ++i) {
            builder.append((String)nodes.get(i));
        }
        builder.append("</div>");
        builder.append("<div class='clearfix'></div>");
        builder.append(this.getRequestQueue());
        if (request.getParameter("config") != null) {
            builder.append(this.getConfigInfo(request.getParameter("configDebug") != null));
        } else {
            builder.append("<a href='?config=true&configDebug=true'>view config</a>");
        }
        builder.append("</div>");
        builder.append("</body>");
        builder.append("</html>");
        ByteArrayInputStream in = new ByteArrayInputStream(builder.toString().getBytes("UTF-8"));
        try {
            ByteStreams.copy(in, response.getOutputStream());
        }
        finally {
            ((InputStream)in).close();
            response.getOutputStream().close();
        }
    }

    private Object getRequestQueue() {
        StringBuilder builder = new StringBuilder();
        builder.append("<div>");
        int numUnprocessedRequests = this.getRegistry().getNewSessionRequestCount();
        if (numUnprocessedRequests > 0) {
            builder.append(String.format("%d requests waiting for a slot to be free.", numUnprocessedRequests));
        }
        builder.append("<ul>");
        for (DesiredCapabilities req : this.getRegistry().getDesiredCapabilities()) {
            builder.append("<li>").append(req).append("</li>");
        }
        builder.append("</ul>");
        builder.append("</div>");
        return builder.toString();
    }

    private Object getHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append("<div id='header'>");
        builder.append("<h1><a href='/grid/console'>Selenium</a></h1>");
        builder.append("<h2>Grid Console v.");
        builder.append(coreVersion);
        builder.append("</h2>");
        builder.append("<div><a id='helplink' target='_blank' href='https://github.com/SeleniumHQ/selenium/wiki/Grid2'>Help</a></div>");
        builder.append("</div>");
        builder.append("");
        return builder.toString();
    }

    private String getConfigInfo(boolean verbose) {
        StringBuilder builder = new StringBuilder();
        GridHubConfiguration config = this.getRegistry().getConfiguration();
        builder.append("<div  id='hubConfig'>");
        builder.append("<b>Config for the hub :</b><br/>");
        builder.append(this.prettyHtmlPrint(config));
        if (verbose) {
            GridHubConfiguration tmp = new GridHubConfiguration();
            builder.append("<b>Config details :</b><br/>");
            builder.append("<b>hub launched with :</b>");
            builder.append(config.toString());
            builder.append("<br/><b>the final configuration comes from :</b><br/>");
            builder.append("<b>the default :</b><br/>");
            builder.append(this.prettyHtmlPrint(tmp));
            builder.append("<br/><b>updated with params :</b></br>");
            tmp.merge(config);
            builder.append(this.prettyHtmlPrint(tmp));
        }
        builder.append("</div>");
        return builder.toString();
    }

    private String prettyHtmlPrint(GridHubConfiguration config) {
        return config.toString("<abbr title='%1$s'>%1$s : </abbr>%2$s</br>");
    }

    private void getVersion() {
        InputStream stream = null;
        try {
            String classPath = this.getClass().getResource(this.getClass().getSimpleName() + ".class").toString();
            String manifest = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            stream = new URL(manifest).openStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (stream == null) {
            log.severe("Couldn't determine version number");
            return;
        }
        try {
            Manifest manifest = new Manifest(stream);
            coreVersion = manifest.getEntries().get("Build-Info").getValue("Selenium-Version");
        }
        catch (IOException e) {
            log.severe("Cannot load version from VERSION.txt" + e.getMessage());
        }
    }
}

