/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.handler;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.web.servlet.handler.RequestType;
import org.openqa.grid.web.servlet.handler.SeleniumBasedRequest;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.JsonToBeanConverter;

public class WebDriverRequest
extends SeleniumBasedRequest {
    public WebDriverRequest(HttpServletRequest httpServletRequest, Registry registry) {
        super(httpServletRequest, registry);
    }

    @Override
    public RequestType extractRequestType() {
        ExternalSessionKey externalKey;
        if ("/session".equals(this.getPathInfo())) {
            return RequestType.START_SESSION;
        }
        if (this.getMethod().equalsIgnoreCase("DELETE") && (externalKey = ExternalSessionKey.fromWebDriverRequest(this.getPathInfo())) != null && this.getPathInfo().endsWith("/session/" + externalKey.getKey())) {
            return RequestType.STOP_SESSION;
        }
        return RequestType.REGULAR;
    }

    @Override
    public ExternalSessionKey extractSession() {
        if (this.getRequestType() == RequestType.START_SESSION) {
            throw new IllegalAccessError("Cannot call that method of a new session request.");
        }
        String path = this.getPathInfo();
        return ExternalSessionKey.fromWebDriverRequest(path);
    }

    @Override
    public Map<String, Object> extractDesiredCapability() {
        String json = this.getBody();
        try {
            JsonObject map = new JsonParser().parse(json).getAsJsonObject();
            JsonObject dc = map.get("desiredCapabilities").getAsJsonObject();
            return new JsonToBeanConverter().convert(Map.class, dc);
        }
        catch (JsonSyntaxException e) {
            throw new GridException("Cannot extract a capabilities from the request " + json);
        }
    }

    @Override
    public String getNewSessionRequestedCapability(TestSession session) {
        JsonObject c = new JsonObject();
        c.add("desiredCapabilities", new BeanToJsonConverter().convertObject(session.getRequestedCapabilities()));
        return new Gson().toJson(c);
    }
}

