/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.internal.Executable;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.service.DriverService;

public class GeckoDriverService
extends DriverService {
    public static final String GECKO_DRIVER_EXE_PROPERTY = "webdriver.gecko.driver";

    public GeckoDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static GeckoDriverService createDefaultService() {
        return (GeckoDriverService)((Builder)new Builder().usingAnyFreePort()).build();
    }

    @Override
    protected void waitUntilAvailable() throws MalformedURLException {
        PortProber.waitForPortUp(this.getUrl().getPort(), 20, TimeUnit.SECONDS);
    }

    public static class Builder
    extends DriverService.Builder<GeckoDriverService, Builder> {
        @Override
        protected File findDefaultExecutable() {
            try {
                return GeckoDriverService.findExecutable("geckodriver", GeckoDriverService.GECKO_DRIVER_EXE_PROPERTY, "https://github.com/mozilla/geckodriver", "https://github.com/mozilla/geckodriver/releases");
            }
            catch (IllegalStateException e) {
                return GeckoDriverService.findExecutable("wires", GeckoDriverService.GECKO_DRIVER_EXE_PROPERTY, "https://github.com/mozilla/geckodriver", "https://github.com/mozilla/geckodriver/releases");
            }
        }

        @Override
        protected ImmutableList<String> createArgs() {
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            argsBuilder.add(String.format("--port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                argsBuilder.add(String.format("--log-file=\"%s\"", this.getLogFile().getAbsolutePath()));
            }
            argsBuilder.add("-b");
            argsBuilder.add(new Executable(null).getPath());
            return argsBuilder.build();
        }

        @Override
        protected GeckoDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new GeckoDriverService(exe, port, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

