/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Platform;
import org.openqa.selenium.net.EphemeralPortRangeDetector;
import org.openqa.selenium.net.FixedIANAPortRange;
import org.openqa.selenium.net.LinuxEphemeralPortRangeDetector;
import org.openqa.selenium.net.OlderWindowsVersionEphemeralPortDetector;

public class PortProber {
    private static final Random random = new Random();
    private static final EphemeralPortRangeDetector ephemeralRangeDetector;
    public static final int HIGHEST_PORT = 65535;
    public static final int START_OF_USER_PORTS = 1024;

    private PortProber() {
    }

    public static int findFreePort() {
        for (int i = 0; i < 5; ++i) {
            int seedPort = PortProber.createAcceptablePort();
            int suggestedPort = PortProber.checkPortIsFree(seedPort);
            if (suggestedPort == -1) continue;
            return suggestedPort;
        }
        throw new RuntimeException("Unable to find a free port");
    }

    public static Callable<Integer> freeLocalPort(final int port) {
        return new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (PortProber.checkPortIsFree(port) != -1) {
                    return port;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int createAcceptablePort() {
        Random random = PortProber.random;
        synchronized (random) {
            int LAST_PORT;
            int FIRST_PORT;
            int freeAbove = 65535 - ephemeralRangeDetector.getHighestEphemeralPort();
            int freeBelow = Math.max(0, ephemeralRangeDetector.getLowestEphemeralPort() - 1024);
            if (freeAbove > freeBelow) {
                FIRST_PORT = ephemeralRangeDetector.getHighestEphemeralPort();
                LAST_PORT = 65535;
            } else {
                FIRST_PORT = 1024;
                LAST_PORT = ephemeralRangeDetector.getLowestEphemeralPort();
            }
            if (FIRST_PORT == LAST_PORT) {
                return FIRST_PORT;
            }
            if (FIRST_PORT > LAST_PORT) {
                throw new UnsupportedOperationException("Could not find ephemeral port to use");
            }
            int randomInt = PortProber.random.nextInt();
            int portWithoutOffset = Math.abs(randomInt % (LAST_PORT - FIRST_PORT + 1));
            return portWithoutOffset + FIRST_PORT;
        }
    }

    private static int checkPortIsFree(int port) {
        try {
            ServerSocket socket = new ServerSocket();
            socket.setReuseAddress(true);
            socket.bind(new InetSocketAddress("localhost", port));
            int localPort = socket.getLocalPort();
            socket.close();
            return localPort;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static boolean pollPort(int port) {
        return PortProber.pollPort(port, 15, TimeUnit.SECONDS);
    }

    public static boolean pollPort(int port, int timeout, TimeUnit unit) {
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < end) {
            try {
                Socket socket = new Socket();
                socket.setReuseAddress(true);
                socket.bind(new InetSocketAddress("localhost", port));
                socket.close();
                return true;
            }
            catch (ConnectException socket) {
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public static void waitForPortUp(int port, int timeout, TimeUnit unit) {
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < end) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress("localhost", port), 1000);
                socket.close();
                return;
            }
            catch (ConnectException socket) {
            }
            catch (SocketTimeoutException socket) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        Platform current = Platform.getCurrent();
        ephemeralRangeDetector = current.is(Platform.LINUX) ? LinuxEphemeralPortRangeDetector.getInstance() : (current.is(Platform.XP) ? new OlderWindowsVersionEphemeralPortDetector() : new FixedIANAPortRange());
    }
}

