/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.HasIdentity;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteMouse;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;

public class RemoteWebElement
implements WebElement,
FindsByLinkText,
FindsById,
FindsByName,
FindsByTagName,
FindsByClassName,
FindsByCssSelector,
FindsByXPath,
WrapsDriver,
Locatable,
HasIdentity,
TakesScreenshot {
    private String foundBy;
    protected String id;
    protected RemoteWebDriver parent;
    protected RemoteMouse mouse;
    protected FileDetector fileDetector;

    protected void setFoundBy(SearchContext foundFrom, String locator, String term) {
        this.foundBy = String.format("[%s] -> %s: %s", foundFrom, locator, term);
    }

    public void setParent(RemoteWebDriver parent) {
        this.parent = parent;
        this.mouse = (RemoteMouse)parent.getMouse();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFileDetector(FileDetector detector) {
        this.fileDetector = detector;
    }

    @Override
    public void click() {
        this.execute("clickElement", ImmutableMap.of("id", this.id));
    }

    @Override
    public void submit() {
        if (this.parent.getW3CStandardComplianceLevel() == 0) {
            this.execute("submitElement", ImmutableMap.of("id", this.id));
        } else {
            WebElement form = this.findElement(By.xpath("./ancestor-or-self::form"));
            this.parent.executeScript("var e = arguments[0].ownerDocument.createEvent('Event');e.initEvent('submit', true, true);if (arguments[0].dispatchEvent(e)) { arguments[0].submit() }", form);
        }
    }

    @Override
    public void sendKeys(CharSequence ... keysToSend) {
        CharSequence[] keys;
        File localFile = this.fileDetector.getLocalFile(keysToSend);
        if (localFile != null) {
            String remotePath = this.upload(localFile);
            keysToSend = new CharSequence[]{remotePath};
        }
        if (this.parent.getW3CStandardComplianceLevel() == 0) {
            keys = keysToSend;
        } else {
            StringBuilder sb = new StringBuilder();
            for (CharSequence s : keysToSend) {
                sb.append(s);
            }
            keys = new CharSequence[sb.length()];
            for (int i = 0; i < sb.length(); ++i) {
                keys[i] = Character.toString(sb.charAt(i));
            }
        }
        this.execute("sendKeysToElement", ImmutableMap.of("id", this.id, "value", keys));
    }

    private String upload(File localFile) {
        if (!localFile.isFile()) {
            throw new WebDriverException("You may only upload files: " + localFile);
        }
        try {
            String zip = new Zip().zipFile(localFile.getParentFile(), localFile);
            Response response = this.execute("uploadFile", ImmutableMap.of("file", zip));
            return (String)response.getValue();
        }
        catch (IOException e) {
            throw new WebDriverException("Cannot upload " + localFile, e);
        }
    }

    @Override
    public void clear() {
        this.execute("clearElement", ImmutableMap.of("id", this.id));
    }

    @Override
    public String getTagName() {
        return (String)this.execute("getElementTagName", ImmutableMap.of("id", this.id)).getValue();
    }

    @Override
    public String getAttribute(String name) {
        Object value = this.execute("getElementAttribute", ImmutableMap.of("id", this.id, "name", name)).getValue();
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public boolean isSelected() {
        Object value = this.execute("isElementSelected", ImmutableMap.of("id", this.id)).getValue();
        try {
            return (Boolean)value;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to Boolean: " + value, ex);
        }
    }

    @Override
    public boolean isEnabled() {
        Object value = this.execute("isElementEnabled", ImmutableMap.of("id", this.id)).getValue();
        try {
            return (Boolean)value;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to Boolean: " + value, ex);
        }
    }

    @Override
    public String getText() {
        Response response = this.execute("getElementText", ImmutableMap.of("id", this.id));
        return (String)response.getValue();
    }

    @Override
    public String getCssValue(String propertyName) {
        Response response = this.execute("getElementValueOfCssProperty", ImmutableMap.of("id", this.id, "propertyName", propertyName));
        return (String)response.getValue();
    }

    @Override
    public List<WebElement> findElements(By by) {
        return by.findElements(this);
    }

    @Override
    public WebElement findElement(By by) {
        return by.findElement(this);
    }

    protected WebElement findElement(String using, String value) {
        WebElement element;
        Response response = this.execute("findChildElement", ImmutableMap.of("id", this.id, "using", using, "value", value));
        Object responseValue = response.getValue();
        try {
            element = (WebElement)responseValue;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to WebElement: " + value, ex);
        }
        this.parent.setFoundBy(this, element, using, value);
        return element;
    }

    protected List<WebElement> findElements(String using, String value) {
        List allElements;
        Response response = this.execute("findChildElements", ImmutableMap.of("id", this.id, "using", using, "value", value));
        Object responseValue = response.getValue();
        try {
            allElements = (List)responseValue;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<WebElement>: " + responseValue, ex);
        }
        for (WebElement element : allElements) {
            this.parent.setFoundBy(this, element, using, value);
        }
        return allElements;
    }

    @Override
    public WebElement findElementById(String using) {
        if (this.parent.getW3CStandardComplianceLevel() == 0) {
            return this.findElement("id", using);
        }
        return this.findElementByCssSelector("#" + RemoteWebDriver.cssEscape(using));
    }

    @Override
    public List<WebElement> findElementsById(String using) {
        if (this.parent.getW3CStandardComplianceLevel() == 0) {
            return this.findElements("id", using);
        }
        return this.findElementsByCssSelector("#" + RemoteWebDriver.cssEscape(using));
    }

    @Override
    public WebElement findElementByLinkText(String using) {
        return this.findElement("link text", using);
    }

    @Override
    public List<WebElement> findElementsByLinkText(String using) {
        return this.findElements("link text", using);
    }

    @Override
    public WebElement findElementByName(String using) {
        if (this.parent.getW3CStandardComplianceLevel() == 0) {
            return this.findElement("name", using);
        }
        return this.findElementByCssSelector("*[name='" + using + "']");
    }

    @Override
    public List<WebElement> findElementsByName(String using) {
        if (this.parent.getW3CStandardComplianceLevel() == 0) {
            return this.findElements("name", using);
        }
        return this.findElementsByCssSelector("*[name='" + using + "']");
    }

    @Override
    public WebElement findElementByClassName(String using) {
        if (this.parent.getW3CStandardComplianceLevel() == 0) {
            return this.findElement("class name", using);
        }
        return this.findElementByCssSelector("." + RemoteWebDriver.cssEscape(using));
    }

    @Override
    public List<WebElement> findElementsByClassName(String using) {
        if (this.parent.getW3CStandardComplianceLevel() == 0) {
            return this.findElements("class name", using);
        }
        return this.findElementsByCssSelector("." + RemoteWebDriver.cssEscape(using));
    }

    @Override
    public WebElement findElementByCssSelector(String using) {
        return this.findElement("css selector", using);
    }

    @Override
    public List<WebElement> findElementsByCssSelector(String using) {
        return this.findElements("css selector", using);
    }

    @Override
    public WebElement findElementByXPath(String using) {
        return this.findElement("xpath", using);
    }

    @Override
    public List<WebElement> findElementsByXPath(String using) {
        return this.findElements("xpath", using);
    }

    @Override
    public WebElement findElementByPartialLinkText(String using) {
        return this.findElement("partial link text", using);
    }

    @Override
    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.findElements("partial link text", using);
    }

    @Override
    public WebElement findElementByTagName(String using) {
        if (this.parent.getW3CStandardComplianceLevel() == 0) {
            return this.findElement("tag name", using);
        }
        return this.findElementByCssSelector(using);
    }

    @Override
    public List<WebElement> findElementsByTagName(String using) {
        if (this.parent.getW3CStandardComplianceLevel() == 0) {
            return this.findElements("tag name", using);
        }
        return this.findElementsByCssSelector(using);
    }

    protected Response execute(String command, Map<String, ?> parameters) {
        return this.parent.execute(command, parameters);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebElement)) {
            return false;
        }
        WebElement other = (WebElement)obj;
        while (other instanceof WrapsElement) {
            other = ((WrapsElement)((Object)other)).getWrappedElement();
        }
        if (!(other instanceof RemoteWebElement)) {
            return false;
        }
        RemoteWebElement otherRemoteWebElement = (RemoteWebElement)other;
        return this.id.equals(otherRemoteWebElement.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public WebDriver getWrappedDriver() {
        return this.parent;
    }

    @Override
    public boolean isDisplayed() {
        Object value = this.execute("isElementDisplayed", ImmutableMap.of("id", this.id)).getValue();
        try {
            return (Boolean)value;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to Boolean: " + value, ex);
        }
    }

    @Override
    public Point getLocation() {
        Response response = this.parent.getW3CStandardComplianceLevel() == 0 ? this.execute("getElementLocation", ImmutableMap.of("id", this.id)) : this.execute("getElementRect", ImmutableMap.of("id", this.id));
        Map rawPoint = (Map)response.getValue();
        int x = ((Number)rawPoint.get("x")).intValue();
        int y = ((Number)rawPoint.get("y")).intValue();
        return new Point(x, y);
    }

    @Override
    public Dimension getSize() {
        Response response = this.parent.getW3CStandardComplianceLevel() == 0 ? this.execute("getElementSize", ImmutableMap.of("id", this.id)) : this.execute("getElementRect", ImmutableMap.of("id", this.id));
        Map rawSize = (Map)response.getValue();
        int width = ((Number)rawSize.get("width")).intValue();
        int height = ((Number)rawSize.get("height")).intValue();
        return new Dimension(width, height);
    }

    @Override
    public Rectangle getRect() {
        Response response = this.execute("getElementRect", ImmutableMap.of("id", this.id));
        Map rawRect = (Map)response.getValue();
        int x = ((Number)rawRect.get("x")).intValue();
        int y = ((Number)rawRect.get("y")).intValue();
        int width = ((Number)rawRect.get("width")).intValue();
        int height = ((Number)rawRect.get("height")).intValue();
        return new Rectangle(x, y, height, width);
    }

    @Override
    public Coordinates getCoordinates() {
        return new Coordinates(){

            @Override
            public Point onScreen() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Point inViewPort() {
                if (RemoteWebElement.this.parent.getW3CStandardComplianceLevel() == 0) {
                    Response response = RemoteWebElement.this.execute("getElementLocationOnceScrolledIntoView", ImmutableMap.of("id", RemoteWebElement.this.getId()));
                    Map mapped = (Map)response.getValue();
                    return new Point(((Number)mapped.get("x")).intValue(), ((Number)mapped.get("y")).intValue());
                }
                Map mapped = (Map)RemoteWebElement.this.parent.executeScript("return arguments[0].getBoundingClientRect()", RemoteWebElement.this);
                return new Point(((Number)mapped.get("x")).intValue(), ((Number)mapped.get("y")).intValue());
            }

            @Override
            public Point onPage() {
                return RemoteWebElement.this.getLocation();
            }

            @Override
            public Object getAuxiliary() {
                return RemoteWebElement.this.getId();
            }
        };
    }

    @Override
    @Beta
    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        Response response = this.execute("elementScreenshot", ImmutableMap.of("id", this.id));
        Object result = response.getValue();
        if (result instanceof String) {
            String base64EncodedPng = (String)result;
            return outputType.convertFromBase64Png(base64EncodedPng);
        }
        if (result instanceof byte[]) {
            String base64EncodedPng = new String((byte[])result);
            return outputType.convertFromBase64Png(base64EncodedPng);
        }
        throw new RuntimeException(String.format("Unexpected result for %s command: %s", "elementScreenshot", result == null ? "null" : result.getClass().getName() + " instance"));
    }

    public String toString() {
        if (this.foundBy == null) {
            return String.format("[%s -> unknown locator]", super.toString());
        }
        return String.format("[%s]", this.foundBy);
    }
}

