/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.beust.jcommander.JCommander;
import javax.servlet.Servlet;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.grid.shared.GridNodeServer;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DefaultDriverSessions;
import org.openqa.selenium.remote.server.DriverServlet;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.DeleteSession;
import org.seleniumhq.jetty9.server.Connector;
import org.seleniumhq.jetty9.server.HttpConfiguration;
import org.seleniumhq.jetty9.server.HttpConnectionFactory;
import org.seleniumhq.jetty9.server.Server;
import org.seleniumhq.jetty9.server.ServerConnector;
import org.seleniumhq.jetty9.servlet.ServletContextHandler;
import org.seleniumhq.jetty9.util.thread.QueuedThreadPool;

public class SeleniumServer
implements GridNodeServer {
    private Server server;
    private DefaultDriverSessions driverSessions;
    private StandaloneConfiguration configuration;
    private Thread shutDownHook;
    private final Object shutdownLock = new Object();
    private static final int MAX_SHUTDOWN_RETRIES = 8;

    public SeleniumServer(StandaloneConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public int getRealPort() {
        if (this.server.isStarted()) {
            ServerConnector socket = (ServerConnector)this.server.getConnectors()[0];
            return socket.getPort();
        }
        return this.configuration.port;
    }

    private void addRcSupport(ServletContextHandler handler) {
        try {
            Class<Servlet> rcServlet = Class.forName("com.thoughtworks.selenium.webdriven.WebDriverBackedSeleniumServlet", false, this.getClass().getClassLoader()).asSubclass(Servlet.class);
            handler.addServlet(rcServlet, "/selenium-server/driver/");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void setConfiguration(StandaloneConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void boot() {
        this.server = this.configuration.jettyThreads != null && this.configuration.jettyThreads > 0 ? new Server(new QueuedThreadPool(this.configuration.jettyThreads)) : new Server();
        ServletContextHandler handler = new ServletContextHandler();
        this.driverSessions = new DefaultDriverSessions();
        handler.setAttribute(DriverServlet.SESSIONS_KEY, this.driverSessions);
        handler.setContextPath("/");
        handler.addServlet(DriverServlet.class, "/wd/hub/*");
        if (this.configuration.browserTimeout != null) {
            handler.setInitParameter("webdriver.server.browser.timeout", String.valueOf(this.configuration.browserTimeout));
        }
        if (this.configuration.timeout != null) {
            handler.setInitParameter("webdriver.server.session.timeout", String.valueOf(this.configuration.timeout));
        }
        this.addRcSupport(handler);
        this.server.setHandler(handler);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        ServerConnector http = new ServerConnector(this.server, new HttpConnectionFactory(httpConfig));
        if (this.configuration.port == null) {
            this.configuration.port = 4444;
        }
        http.setPort(this.configuration.port);
        http.setIdleTimeout(500000L);
        this.server.setConnectors(new Connector[]{http});
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        int numTries = 0;
        Exception shutDownException = null;
        try {
            if (this.shutDownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        while (numTries <= 8) {
            ++numTries;
            try {
                Object object = this.shutdownLock;
                synchronized (object) {
                    this.server.stop();
                    break;
                }
            }
            catch (Exception ex) {
                shutDownException = ex;
            }
        }
        this.stopAllBrowsers();
        if (numTries > 8 && null != shutDownException) {
            throw new RuntimeException(shutDownException);
        }
    }

    private void stopAllBrowsers() {
        for (SessionId sessionId : this.driverSessions.getSessions()) {
            Session session = this.driverSessions.get(sessionId);
            DeleteSession deleteSession = new DeleteSession(session);
            try {
                deleteSession.call();
                this.driverSessions.deleteSession(sessionId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] argv) {
        StandaloneConfiguration configuration = new StandaloneConfiguration();
        JCommander jCommander = new JCommander((Object)configuration, argv);
        jCommander.setProgramName("selenium-3-server");
        if (configuration.help) {
            StringBuilder message = new StringBuilder();
            jCommander.usage(message);
            System.err.println(message.toString());
            return;
        }
        SeleniumServer server = new SeleniumServer(configuration);
        server.boot();
    }

    public static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        StandaloneConfiguration args = new StandaloneConfiguration();
        JCommander jCommander = new JCommander(args);
        jCommander.usage();
    }

    private class ShutDownHook
    implements Runnable {
        private final SeleniumServer selenium;

        ShutDownHook(SeleniumServer selenium) {
            this.selenium = selenium;
        }

        @Override
        public void run() {
            this.selenium.stop();
        }
    }
}

