/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.io.IOException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.safari.SafariDriverCommandExecutor;
import org.openqa.selenium.safari.SafariDriverService;
import org.openqa.selenium.safari.SafariOptions;

public class SafariDriver
extends RemoteWebDriver {
    public static final String USE_LEGACY_DRIVER_CAPABILITY = "useLegacyDriver";
    private SafariDriverService service;

    public SafariDriver() {
        this(new SafariOptions());
    }

    public SafariDriver(Capabilities desiredCapabilities) {
        this(SafariOptions.fromCapabilities(desiredCapabilities));
    }

    public SafariDriver(SafariOptions safariOptions) {
        super(SafariDriver.getExecutor(safariOptions), (Capabilities)safariOptions.toCapabilities());
    }

    private static CommandExecutor getExecutor(SafariOptions options) {
        Object useLegacy = options.toCapabilities().getCapability(USE_LEGACY_DRIVER_CAPABILITY);
        SafariDriverService service = SafariDriverService.createDefaultService(options);
        if (!(useLegacy != null && ((Boolean)useLegacy).booleanValue() || service == null)) {
            return new DriverCommandExecutor(service);
        }
        return new SafariDriverCommandExecutor(options);
    }

    @Override
    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    @Override
    protected void startClient() {
        CommandExecutor commandExecutor = this.getCommandExecutor();
        if (commandExecutor instanceof SafariDriverCommandExecutor) {
            try {
                ((SafariDriverCommandExecutor)commandExecutor).start();
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        } else {
            super.startClient();
        }
    }

    @Override
    protected void stopClient() {
        CommandExecutor commandExecutor = this.getCommandExecutor();
        if (commandExecutor instanceof SafariDriverCommandExecutor) {
            ((SafariDriverCommandExecutor)commandExecutor).stop();
        } else {
            super.stopClient();
        }
    }

    @Override
    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        String base64 = (String)this.execute("screenshot").getValue();
        return target.convertFromBase64Png(base64);
    }
}

