/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.SafariOptions;

public class SafariDriverService
extends DriverService {
    private static final File SAFARI_DRIVER_EXECUTABLE = new File("/usr/bin/safaridriver");

    public SafariDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static SafariDriverService createDefaultService(SafariOptions options) {
        if (SAFARI_DRIVER_EXECUTABLE.exists()) {
            return (SafariDriverService)((Builder)new Builder().usingPort(options.getPort())).build();
        }
        return null;
    }

    public static class Builder
    extends DriverService.Builder<SafariDriverService, Builder> {
        @Override
        protected File findDefaultExecutable() {
            return SAFARI_DRIVER_EXECUTABLE;
        }

        @Override
        protected ImmutableList<String> createArgs() {
            return ImmutableList.of("--port", String.valueOf(this.getPort()));
        }

        @Override
        protected SafariDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new SafariDriverService(exe, port, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

